/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.selection;

import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.selection.FlatSpawnablePositionWeightedSelector;
import com.cobblemon.mod.common.api.spawning.selection.SpawnSelectionData;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\bf\u0018\u0000 \u001b*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001\u001bJ-\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J9\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00a2\u0006\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001c\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;", "T", "", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePositions", "getSelectionData", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;", "selectionData", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "selectSpawnAction", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "", "maxSpawns", "select", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;I)Ljava/util/List;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "", "getProbabilities", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Ljava/util/Map;", "getTotalWeights", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSpawningSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawningSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/SpawningSelector\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n216#2,2:72\n*S KotlinDebug\n*F\n+ 1 SpawningSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/SpawningSelector\n*L\n66#1:72,2\n*E\n"})
public interface SpawningSelector<T extends SpawnSelectionData> {
    @NotNull
    public static final Companion Companion = com.cobblemon.mod.common.api.spawning.selection.SpawningSelector$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final FlatSpawnablePositionWeightedSelector DEFAULT = new FlatSpawnablePositionWeightedSelector();

    @NotNull
    public T getSelectionData(@NotNull Spawner var1, @NotNull SpawnBucket var2, @NotNull List<? extends SpawnablePosition> var3);

    @Nullable
    public SpawnAction<?> selectSpawnAction(@NotNull Spawner var1, @NotNull SpawnBucket var2, @NotNull T var3);

    @NotNull
    default public List<SpawnAction<?>> select(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions, int maxSpawns) {
        SpawnAction<?> spawnAction;
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        T selectionData = this.getSelectionData(spawner, bucket, spawnablePositions);
        List<SpawnAction<?>> spawnActions = selectionData.getSpawnActions();
        while (spawnActions.size() < maxSpawns && (spawnAction = this.selectSpawnAction(spawner, bucket, selectionData)) != null) {
            spawnActions.add(spawnAction);
        }
        return spawnActions;
    }

    @NotNull
    default public Map<SpawnDetail, Float> getProbabilities(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        Map<SpawnDetail, Float> weights = this.getTotalWeights(spawner, bucket, spawnablePositions);
        float totalWeight = CollectionsKt.sumOfFloat((Iterable)weights.values());
        Map percentages = new LinkedHashMap();
        Map<SpawnDetail, Float> $this$forEach$iv = weights;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SpawnDetail, Float>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SpawnDetail, Float> element$iv;
            Map.Entry<SpawnDetail, Float> entry = element$iv = iterator.next();
            boolean bl = false;
            SpawnDetail spawnDetail = entry.getKey();
            float weight = ((Number)entry.getValue()).floatValue();
            percentages.put(spawnDetail, RangesKt.coerceIn((Comparable)Float.valueOf(weight / totalWeight * 100.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)100.0f)));
        }
        return percentages;
    }

    @NotNull
    public Map<SpawnDetail, Float> getTotalWeights(@NotNull Spawner var1, @NotNull SpawnBucket var2, @NotNull List<? extends SpawnablePosition> var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector;", "DEFAULT", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector;", "common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <T extends SpawnSelectionData> List<SpawnAction<?>> select(@NotNull SpawningSelector<T> $this, @NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions, int maxSpawns) {
            Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
            return ((SpawningSelector)$this).select(spawner, bucket, spawnablePositions, maxSpawns);
        }

        @Deprecated
        @NotNull
        public static <T extends SpawnSelectionData> Map<SpawnDetail, Float> getProbabilities(@NotNull SpawningSelector<T> $this, @NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
            Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
            return ((SpawningSelector)$this).getProbabilities(spawner, bucket, spawnablePositions);
        }
    }
}

