/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.animation;

import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.PoseAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJW\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001f\u0010\u001eR\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b \u0010\u001e\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/PitchTiltAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/PoseAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "bone", "", "maxChangePerTick", "minPitch", "maxPitch", "<init>", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;FFF)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "limbSwing", "limbSwingAmount", "ageInTicks", "headYaw", "headPitch", "intensity", "", "setupAnim", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFFF)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "getBone", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "F", "getMaxChangePerTick", "()F", "getMinPitch", "getMaxPitch", "Companion", "common"})
public final class PitchTiltAnimation
extends PoseAnimation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bone bone;
    private final float maxChangePerTick;
    private final float minPitch;
    private final float maxPitch;
    @NotNull
    public static final String PREVIOUS_ANGLE = "previous_pitch_tilt_angle";
    @NotNull
    public static final String CORRECTED_ANGLE = "corrected_pitch_tilt_angle";
    @NotNull
    public static final String PITCHED_TILT = "has_pitched_tilt";

    public PitchTiltAnimation(@NotNull Bone bone, float maxChangePerTick, float minPitch, float maxPitch) {
        Intrinsics.checkNotNullParameter((Object)bone, (String)"bone");
        this.bone = bone;
        this.maxChangePerTick = maxChangePerTick;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
    }

    public /* synthetic */ PitchTiltAnimation(Bone bone, float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = -45.0f;
        }
        if ((n & 8) != 0) {
            f3 = 45.0f;
        }
        this(bone, f, f2, f3);
    }

    @NotNull
    public final Bone getBone() {
        return this.bone;
    }

    public final float getMaxChangePerTick() {
        return this.maxChangePerTick;
    }

    public final float getMinPitch() {
        return this.minPitch;
    }

    public final float getMaxPitch() {
        return this.maxPitch;
    }

    @Override
    protected void setupAnim(@NotNull RenderContext context, @NotNull PosableModel model, @NotNull PosableState state, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, float intensity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        class_1297 class_12972 = context.getEntity();
        if (class_12972 == null) {
            return;
        }
        class_1297 entity = class_12972;
        List list = entity.method_5685();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
        if (!((Collection)list).isEmpty()) {
            return;
        }
        class_243 delta = entity.method_18798();
        double vertical = delta.field_1351;
        double horizontal = delta.method_37267();
        float angleOfMotion = RangesKt.coerceIn((float)(horizontal == 0.0 ? (vertical > 0.0 ? this.maxPitch : (vertical < 0.0 ? this.minPitch : 0.0f)) : AngleExtensionsKt.toDegrees(class_3532.method_15349((double)vertical, (double)horizontal))), (float)this.minPitch, (float)this.maxPitch) * (float)-1;
        Float f = state.getNumbers().get(PREVIOUS_ANGLE);
        float lastAngle = f != null ? f.floatValue() : 0.0f;
        float change = RangesKt.coerceIn((float)(angleOfMotion - lastAngle), (float)(-this.maxChangePerTick), (float)this.maxChangePerTick);
        if (!state.getRenderMarkers().contains(PITCHED_TILT)) {
            state.getNumbers().remove(CORRECTED_ANGLE);
            float correctedAngle = (lastAngle + change) * intensity;
            ModelPartExtensionsKt.addRotation(this.bone, 0, AngleExtensionsKt.toRadians(Float.valueOf(correctedAngle)));
            state.getNumbers().put(PREVIOUS_ANGLE, Float.valueOf(correctedAngle));
        } else {
            ModelPartExtensionsKt.addRotation(this.bone, 0, AngleExtensionsKt.toRadians(Float.valueOf(change)) * intensity);
            state.getNumbers().put(PREVIOUS_ANGLE, Float.valueOf(lastAngle + change * intensity));
        }
        ((Collection)state.getRenderMarkers()).add(PITCHED_TILT);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/PitchTiltAnimation$Companion;", "", "<init>", "()V", "", "PREVIOUS_ANGLE", "Ljava/lang/String;", "CORRECTED_ANGLE", "PITCHED_TILT", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

