/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.SpawningZoneGenerator;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.AreaSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.SpawnBucketArgumentType;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/command/CheckSpawnsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/class_3222;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;)I", "Lnet/minecraft/class_5250;", "name", "", "percentage", "applyColour", "(Lnet/minecraft/class_5250;F)Lnet/minecraft/class_5250;", "PURPLE_THRESHOLD", "F", "RED_THRESHOLD", "YELLOW_THRESHOLD", "Ljava/text/DecimalFormat;", "df", "Ljava/text/DecimalFormat;", "getDf", "()Ljava/text/DecimalFormat;", "common"})
@SourceDebugExtension(value={"SMAP\nCheckSpawnsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSpawnsCommand.kt\ncom/cobblemon/mod/common/command/CheckSpawnsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1869#2,2:131\n1068#2:133\n1869#2,2:134\n*S KotlinDebug\n*F\n+ 1 CheckSpawnsCommand.kt\ncom/cobblemon/mod/common/command/CheckSpawnsCommand\n*L\n86#1:131,2\n97#1:133\n99#1:134,2\n*E\n"})
public final class CheckSpawnsCommand {
    @NotNull
    public static final CheckSpawnsCommand INSTANCE = new CheckSpawnsCommand();
    public static final float PURPLE_THRESHOLD = 0.01f;
    public static final float RED_THRESHOLD = 0.1f;
    public static final float YELLOW_THRESHOLD = 5.0f;
    @NotNull
    private static final DecimalFormat df = new DecimalFormat("#.##");

    private CheckSpawnsCommand() {
    }

    @NotNull
    public final DecimalFormat getDf() {
        return df;
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"checkspawn");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getCHECKSPAWNS(), false, 2, null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"bucket", (ArgumentType)SpawnBucketArgumentType.Companion.spawnBucket()).requires(CheckSpawnsCommand::register$lambda$0)).executes(CheckSpawnsCommand::register$lambda$1)));
    }

    private final int execute(CommandContext<class_2168> context, class_3222 player) {
        if (!Cobblemon.INSTANCE.getConfig().getEnableSpawning()) {
            return 0;
        }
        PlayerSpawner spawner = PlayerExtensionsKt.getSpawner(player);
        SpawnBucket bucket = SpawnBucketArgumentType.Companion.getSpawnBucket(context, "bucket");
        SpawnCause cause = new SpawnCause(spawner, (class_1297)player);
        SpawningZoneGenerator spawningZoneGenerator = Cobblemon.INSTANCE.getSpawningZoneGenerator();
        Spawner spawner2 = spawner;
        class_1937 class_19372 = player.method_37908();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        SpawningZone slice = spawningZoneGenerator.generate(spawner2, new SpawningZoneInput(cause, (class_3218)class_19372, class_3532.method_15384((double)(player.method_23317() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter() / 2.0f))), class_3532.method_15384((double)(player.method_23318() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneHeight() / 2.0f))), class_3532.method_15384((double)(player.method_23321() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter() / 2.0f))), Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter(), Cobblemon.INSTANCE.getConfig().getSpawningZoneHeight(), Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter()));
        List<AreaSpawnablePosition> contexts = Cobblemon.INSTANCE.getAreaSpawnablePositionResolver().resolve(spawner, SpawnablePositionCalculator.Companion.getPrioritizedAreaCalculators(), slice);
        Map<SpawnDetail, Float> spawnProbabilities = spawner.getSelector().getProbabilities(spawner, bucket, contexts);
        Map spawnNames = new LinkedHashMap();
        Map namedProbabilities = new LinkedHashMap();
        Iterable $this$forEach$iv = spawnProbabilities.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            class_5250 nameText = ((SpawnDetail)it.getKey()).getName();
            String nameString = nameText.getString();
            if (!spawnNames.containsKey(nameString)) {
                spawnNames.put(nameString, ((SpawnDetail)it.getKey()).getName());
            }
            Object v = spawnNames.get(nameString);
            Intrinsics.checkNotNull(v);
            class_5250 standardizedNameText = (class_5250)v;
            Map map = namedProbabilities;
            Float f = (Float)namedProbabilities.get(standardizedNameText);
            Float f2 = Float.valueOf((f != null ? f.floatValue() : 0.0f) + ((Number)it.getValue()).floatValue());
            map.put(standardizedNameText, f2);
        }
        Iterable $this$sortedByDescending$iv = namedProbabilities.entrySet();
        boolean $i$f$sortedByDescending = false;
        List sortedEntries = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Float)it.getValue()));
            }
        });
        List messages = new ArrayList();
        Iterable $this$forEach$iv2 = sortedEntries;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            class_5250 name = (class_5250)entry.getKey();
            float percentage = ((Number)entry.getValue()).floatValue();
            class_5250 message = TextKt.plus(TextKt.plus(name, ": "), INSTANCE.applyColour(TextKt.text(df.format(Float.valueOf(percentage)) + "%"), percentage));
            messages.add(message);
        }
        if (messages.isEmpty()) {
            class_5250 class_52502 = LocalizationUtilsKt.lang("command.checkspawns.nothing", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
            player.method_43496((class_2561)TextKt.red(class_52502));
        } else {
            class_5250 class_52503 = LocalizationUtilsKt.lang("command.checkspawns.spawns", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"lang(...)");
            player.method_43496((class_2561)TextKt.underline(class_52503));
            class_5250 msg = (class_5250)messages.get(0);
            for (class_5250 nextMessage : messages.subList(1, messages.size())) {
                TextKt.add(msg, (class_2561)TextKt.plus(TextKt.text(", "), nextMessage));
            }
            player.method_43496((class_2561)msg);
        }
        return 1;
    }

    @NotNull
    public final class_5250 applyColour(@NotNull class_5250 name, float percentage) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return percentage < 0.01f ? TextKt.lightPurple(name) : (percentage < 0.1f ? TextKt.red(name) : (percentage < 5.0f ? TextKt.yellow(name) : TextKt.green(name)));
    }

    private static final boolean register$lambda$0(class_2168 it) {
        return it.method_44023() != null;
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        class_3222 class_32222 = ((class_2168)it.getSource()).method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<class_2168>)it, class_32222);
    }
}

