/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0012\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/command/PcTakeCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "Lnet/minecraft/class_3222;", "target", "executor", "executeWithTarget", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)I", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
public final class PcTakeCommand {
    @NotNull
    public static final PcTakeCommand INSTANCE = new PcTakeCommand();
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private PcTakeCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"pctake");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getTAKE_POKEMON(), false, 2, null)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(class_2170.method_9244((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)30))).executes(this::execute))));
        dispatcher.register(command);
    }

    private final int execute(CommandContext<class_2168> context) {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        class_3222 executor = class_12972 instanceof class_3222 ? (class_3222)class_12972 : null;
        class_3222 target = class_2186.method_9315(context, (String)"player");
        Intrinsics.checkNotNull((Object)target);
        return this.executeWithTarget(context, target, executor);
    }

    private final int executeWithTarget(CommandContext<class_2168> context, class_3222 target, class_3222 executor) {
        try {
            if (PlayerExtensionsKt.isInBattle(target)) {
                CommandSyntaxException commandSyntaxException = IN_BATTLE_EXCEPTION.create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            int box = IntegerArgumentType.getInteger(context, (String)"box");
            int slot = IntegerArgumentType.getInteger(context, (String)"slot");
            PCStore pc = PlayerExtensionsKt.pc(target);
            if (box > pc.getBoxes().size()) {
                Object[] objectArray = new Object[]{pc.getBoxes().size()};
                ((class_2168)context.getSource()).method_9213((class_2561)LocalizationUtilsKt.commandLang("pctake.too_many_boxes", objectArray));
                return 0;
            }
            int boxIndex = box - 1;
            int slotIndex = slot - 1;
            if (slotIndex < 0 || slotIndex >= 30) {
                ((class_2168)context.getSource()).method_9213((class_2561)LocalizationUtilsKt.commandLang("pctake.invalid_slot", new Object[0]));
                return 0;
            }
            Pokemon pokemon = pc.getBoxes().get(boxIndex).get(slotIndex);
            if (pokemon == null) {
                Object[] objectArray = new Object[]{box, slot};
                ((class_2168)context.getSource()).method_9213((class_2561)LocalizationUtilsKt.commandLang("pctake.no_pokemon", objectArray));
                return 0;
            }
            pc.remove((StorePosition)new PCPosition(boxIndex, slotIndex));
            if (executor != null && !Intrinsics.areEqual((Object)executor, (Object)target)) {
                PlayerPartyStore toParty = PlayerExtensionsKt.party(executor);
                toParty.add(pokemon);
                ((class_2168)context.getSource()).method_9226(() -> PcTakeCommand.executeWithTarget$lambda$0(pokemon, target), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> PcTakeCommand.executeWithTarget$lambda$1(pokemon, box, slot), true);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private static final class_2561 executeWithTarget$lambda$0(Pokemon $pokemon, class_3222 $target) {
        Object[] objectArray = new Object[2];
        objectArray[0] = $pokemon.getSpecies().getName();
        Intrinsics.checkNotNullExpressionValue((Object)$target.method_5477().getString(), (String)"getString(...)");
        return (class_2561)LocalizationUtilsKt.commandLang("pctake.taken_other", objectArray);
    }

    private static final class_2561 executeWithTarget$lambda$1(Pokemon $pokemon, int $box, int $slot) {
        Object[] objectArray = new Object[]{$pokemon.getSpecies().getName(), $box, $slot};
        return (class_2561)LocalizationUtilsKt.commandLang("pctake.removed", objectArray);
    }

    static {
        class_5250 class_52502 = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52502));
    }
}

