/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J7\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\"\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/JumpOutOfWaterTask;", "Lnet/minecraft/class_4097;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/class_3218;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "", "start", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "tick", "Lnet/minecraft/class_2338;", "pos", "", "offsetX", "offsetZ", "multiplier", "isWater", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/class_2338;III)Z", "isAirAbove", "inWater", "Z", "getInWater", "()Z", "setInWater", "(Z)V", "Companion", "common"})
public final class JumpOutOfWaterTask
extends class_4097<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inWater;
    private static final int MAX_DURATION = 80;
    private static final int CHANCE = 10;
    @NotNull
    private static final int[] OFFSET_MULTIPLIERS;

    public JumpOutOfWaterTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_37442, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    public final boolean getInWater() {
        return this.inWater;
    }

    public final void setInWater(boolean bl) {
        this.inWater = bl;
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.method_59922().method_43048(10) != 0) {
            return false;
        }
        class_2350 direction = entity.method_5755();
        int x = direction.method_10148();
        int z = direction.method_10165();
        class_2338 blockPos = entity.method_24515();
        for (int offset : OFFSET_MULTIPLIERS) {
            Intrinsics.checkNotNull((Object)blockPos);
            if (this.isWater(entity, blockPos, x, z, offset) && this.isAirAbove(entity, blockPos, x, z, offset)) continue;
            return false;
        }
        return true;
    }

    protected boolean canStillUse(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double d = entity.method_18798().field_1351;
        return !(d * d < (double)0.03f && !(entity.method_36455() == 0.0f) && Math.abs(entity.method_36455()) < 10.0f && entity.method_5799() || entity.method_24828());
    }

    protected void start(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        class_2350 direction = entity.method_5755();
        class_243 newVelocity = entity.method_18798().method_1031((double)direction.method_10148() * 0.6, 0.7, (double)direction.method_10165() * 0.6);
        entity.method_18799(newVelocity);
        entity.getNavigation().method_6340();
    }

    protected void tick(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = this.inWater;
        if (!bl) {
            class_3610 class_36102 = entity.method_37908().method_8316(entity.method_24515());
            Intrinsics.checkNotNullExpressionValue((Object)class_36102, (String)"getFluidState(...)");
            class_3610 fluidState = class_36102;
            this.inWater = fluidState.method_15767(class_3486.field_15517);
        }
        if (this.inWater && !bl) {
            entity.method_5783(class_3417.field_14707, 1.0f, 1.0f);
        }
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 * vec3d.field_1351 < (double)0.03f && !(entity.method_36455() == 0.0f)) {
            entity.method_36457(class_3532.method_17821((float)0.2f, (float)entity.method_36455(), (float)0.0f));
        } else if (vec3d.method_1033() > (double)1.0E-5f) {
            double d = vec3d.method_37267();
            double e = Math.atan2(-vec3d.field_1351, d) * 57.2957763671875;
            entity.method_36457((float)e);
        }
    }

    private final boolean isWater(PokemonEntity entity, class_2338 pos, int offsetX, int offsetZ, int multiplier) {
        class_2338 blockPos = pos.method_10069(offsetX * multiplier, 0, offsetZ * multiplier);
        return entity.method_37908().method_8316(blockPos).method_15767(class_3486.field_15517) && !entity.method_37908().method_8320(blockPos).method_51366();
    }

    private final boolean isAirAbove(PokemonEntity entity, class_2338 pos, int offsetX, int offsetZ, int multiplier) {
        return entity.method_37908().method_8320(pos.method_10069(offsetX * multiplier, 1, offsetZ * multiplier)).method_26215() && entity.method_37908().method_8320(pos.method_10069(offsetX * multiplier, 2, offsetZ * multiplier)).method_26215();
    }

    static {
        int[] nArray = new int[]{0, 1, 4, 5, 6, 7};
        OFFSET_MULTIPLIERS = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/JumpOutOfWaterTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "CHANCE", "", "OFFSET_MULTIPLIERS", "[I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

