/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.world.CobblemonStructureIDs;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5188;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7138;
import net.minecraft.class_8891;
import net.minecraft.class_9822;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3778.class_4182.class})
public abstract class StructurePoolGeneratorMixin {
    Map<String, Integer> generatedStructureGroupCounts;
    private static final Map<String, Integer> structureMaxes;
    private static final Map<class_2960, Set<String>> structureGroups;

    public Set<String> getGroups(class_2960 structureIdentifier) {
        return structureGroups.getOrDefault(structureIdentifier, Set.of());
    }

    public boolean hasReachedMaximum(class_2960 structureIdentifier) {
        Set<String> groups = this.getGroups(structureIdentifier);
        for (String group : groups) {
            int count = this.generatedStructureGroupCounts.getOrDefault(group, 0);
            if (count < structureMaxes.getOrDefault(group, Integer.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    public void incrementStructureCount(class_2960 structureIdentifier) {
        Set<String> groups = this.getGroups(structureIdentifier);
        for (String group : groups) {
            this.generatedStructureGroupCounts.put(group, this.generatedStructureGroupCounts.getOrDefault(group, 0) + 1);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onStructurePoolGeneratorCreation(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random, CallbackInfo ci) {
        this.generatedStructureGroupCounts = new HashMap<String, Integer>();
    }

    @ModifyVariable(method={"tryPlacingChildren"}, at=@At(value="STORE"), ordinal=1)
    private Iterator<class_3784> reduceStructurePoolElementIterator(Iterator<class_3784> iterator) {
        ArrayList<class_3784> reducedList = new ArrayList<class_3784>();
        while (iterator.hasNext()) {
            class_3784 structure = iterator.next();
            class_2960 structurePieceLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(structure);
            if (structurePieceLocationKey == null) {
                reducedList.add(structure);
                continue;
            }
            if (this.hasReachedMaximum(structurePieceLocationKey)) continue;
            reducedList.add(structure);
        }
        return reducedList.iterator();
    }

    @Inject(method={"tryPlacingChildren"}, at={@At(value="NEW", target="net/minecraft/world/level/levelgen/structure/PoolElementStructurePiece", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void afterTryPlacingChildren(class_3790 poolElementStructurePiece, MutableObject<class_265> mutableObject, int i, boolean bl, class_5539 levelHeightAccessor, class_7138 randomState, class_8891 poolAliasLookup, class_9822 liquidSettings, CallbackInfo ci, @Local(ordinal=1) class_3784 structurePoolElement) {
        class_2960 structureLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(structurePoolElement);
        if (structureLocationKey != null) {
            this.incrementStructureCount(structureLocationKey);
        }
    }

    private static class_2960 getCobblemonOnlyLocation(class_3784 structurePoolElement) {
        class_2960 location = StructurePoolGeneratorMixin.getLocationIfAvailable(structurePoolElement);
        if (location == null) {
            return null;
        }
        if (!location.method_12836().equals("cobblemon")) {
            return null;
        }
        return location;
    }

    private static class_2960 getLocationIfAvailable(class_3784 structurePoolElement) {
        if (structurePoolElement instanceof class_5188) {
            class_5188 legacySinglePoolElement = (class_5188)structurePoolElement;
            if (legacySinglePoolElement.field_24015.left().isEmpty()) {
                return null;
            }
            return (class_2960)legacySinglePoolElement.field_24015.left().get();
        }
        if (structurePoolElement instanceof class_3781) {
            class_3781 singlePoolElement = (class_3781)structurePoolElement;
            if (singlePoolElement.field_24015.left().isEmpty()) {
                return null;
            }
            return (class_2960)singlePoolElement.field_24015.left().get();
        }
        return null;
    }

    static {
        structureGroups = new HashMap<class_2960, Set<String>>();
        String pokecenter = "pokecenter";
        String berry = "berry_farm";
        structureGroups.put(CobblemonStructureIDs.VILLAGE_PLAINS_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_DESERT_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_SAVANNA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_SNOWY_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_TAIGA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_LARGE, Set.of(berry));
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        aMap.put(pokecenter, 1);
        aMap.put(berry, 2);
        structureMaxes = Collections.unmodifiableMap(aMap);
    }
}

