/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.trade;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.TradeEvent;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeStartedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.variants.TradeEvolution;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.PlayerTradeParticipant;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010%\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "<init>", "()V", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "trade", "", "removeActiveTrade", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;)Z", "Ljava/util/UUID;", "playerId", "getActiveTrade", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/trade/ActiveTrade;", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "", "onAccept", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)V", "canAccept", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)Z", "Lnet/minecraft/class_3222;", "player", "target", "isValidInteraction", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)Z", "onLogoff", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "player1", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon1", "player2", "pokemon2", "performTrade", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "activeTrades", "Ljava/util/List;", "TradeRequest", "common"})
@SourceDebugExtension(value={"SMAP\nTradeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,126:1\n1#2:127\n40#3,2:128\n42#3,2:133\n45#3:136\n47#3:172\n48#3:175\n18#4,2:130\n15#4,5:163\n20#4:171\n20#4:174\n13805#5:132\n13805#5:168\n13806#5:170\n13806#5:173\n40#6:135\n808#7,11:137\n295#7,2:148\n808#7,11:150\n295#7,2:161\n15#8:169\n*S KotlinDebug\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n*L\n102#1:128,2\n102#1:133,2\n102#1:136\n102#1:172\n102#1:175\n102#1:130,2\n123#1:163,5\n123#1:171\n102#1:174\n102#1:132\n123#1:168\n123#1:170\n102#1:173\n102#1:135\n115#1:137,11\n115#1:148,2\n119#1:150,11\n119#1:161,2\n123#1:169\n*E\n"})
public final class TradeManager
extends RequestManager<TradeRequest> {
    @NotNull
    public static final TradeManager INSTANCE = new TradeManager();
    @NotNull
    private static final List<ActiveTrade> activeTrades;

    private TradeManager() {
    }

    public final boolean removeActiveTrade(@NotNull ActiveTrade trade) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        return activeTrades.remove(trade);
    }

    @Nullable
    public final ActiveTrade getActiveTrade(@NotNull UUID playerId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Iterable iterable = activeTrades;
            for (Object t : iterable) {
                ActiveTrade it = (ActiveTrade)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getPlayer1().getUuid(), (Object)playerId) || Intrinsics.areEqual((Object)it.getPlayer2().getUuid(), (Object)playerId))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TradeOfferExpiredPacket(request);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TradeOfferNotificationPacket(request);
    }

    @Override
    protected void onAccept(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ActiveTrade trade = new ActiveTrade(new PlayerTradeParticipant(request.getReceiver()), new PlayerTradeParticipant(request.getSender()));
        activeTrades.add(trade);
        UUID uUID = request.getSender().method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_5250 class_52502 = request.getReceiver().method_5477().method_27662();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"plainCopy(...)");
        request.sendToSender(new TradeStartedPacket(uUID, class_52502, trade.getPlayer1().getParty().mapNullPreserving(onAccept.1.INSTANCE)));
        UUID uUID2 = request.getReceiver().method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        class_5250 class_52503 = request.getSender().method_5477().method_27662();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"plainCopy(...)");
        request.sendToReceiver(new TradeStartedPacket(uUID2, class_52503, trade.getPlayer2().getParty().mapNullPreserving(onAccept.2.INSTANCE)));
    }

    @Override
    protected boolean canAccept(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getSender()))) {
            request.notifySender(true, "error.insufficient_pokemon.self", new Object[0]);
            Object[] objectArray = new Object[1];
            class_5250 class_52502 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52502);
            request.notifyReceiver(true, "error.insufficient_pokemon.other", objectArray);
        } else if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getReceiver()))) {
            Object[] objectArray = new Object[1];
            class_5250 class_52503 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52503);
            request.notifySender(true, "error.insufficient_pokemon.other", objectArray);
            request.notifyReceiver(true, "error.insufficient_pokemon.self", new Object[0]);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidInteraction(@NotNull class_3222 player, @NotNull class_3222 target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return PlayerExtensionsKt.canInteractWith(player, (class_1309)target, Cobblemon.INSTANCE.getConfig().getTradeMaxDistance());
    }

    @Override
    protected void onLogoff(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onLogoff(player);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ActiveTrade trade = this.getActiveTrade(uUID);
        if (trade != null) {
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            TradeParticipant tradeParticipant = trade.getTradeParticipant(uUID2);
            TradeParticipant oppositeParticipant = trade.getOppositePlayer(tradeParticipant);
            oppositeParticipant.cancelTrade(trade);
            this.removeActiveTrade(trade);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void performTrade(@NotNull TradeParticipant player1, @NotNull Pokemon pokemon1, @NotNull TradeParticipant player2, @NotNull Pokemon pokemon2) {
        void this_$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)player1, (String)"player1");
        Intrinsics.checkNotNullParameter((Object)pokemon1, (String)"pokemon1");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player2");
        Intrinsics.checkNotNullParameter((Object)pokemon2, (String)"pokemon2");
        CancelableObservable<TradeEvent.Pre> cancelableObservable = CobblemonEvents.TRADE_EVENT_PRE;
        Cancelable event$iv = new TradeEvent.Pre(player1, pokemon2, player2, pokemon1);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)$this$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$iv2;
            Object element$iv;
            EventObservable<TradeEvent.Post> $this$firstOrNull$iv;
            Object element$iv$iv;
            Object $this$filterIsInstanceTo$iv$iv;
            Cancelable it;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                Cancelable cancelable = it$iv;
                boolean bl2 = false;
                it = cancelable;
                continue;
            }
            it = (TradeEvent.Pre)it$iv;
            boolean bl3 = false;
            PartyStore party1 = player1.getParty();
            PartyStore party2 = player2.getParty();
            party1.remove(pokemon1);
            party2.remove(pokemon2);
            Pokemon.setFriendship$default(pokemon1, pokemon1.getForm().getBaseFriendship(), false, 2, null);
            Pokemon.setFriendship$default(pokemon2, pokemon2.getForm().getBaseFriendship(), false, 2, null);
            party2.add(pokemon1);
            party1.add(pokemon2);
            Iterable $this$filterIsInstance$iv = pokemon1.getLockedEvolutions();
            boolean $i$f$filterIsInstance = false;
            Object object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                if (!(element$iv$iv instanceof TradeEvolution)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
            while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                element$iv = $this$filterIsInstanceTo$iv$iv.next();
                TradeEvolution it2 = (TradeEvolution)element$iv;
                boolean bl4 = false;
                if (!it2.attemptEvolution(pokemon1, (Object)pokemon2)) continue;
                break;
            }
            $this$filterIsInstance$iv = pokemon2.getLockedEvolutions();
            $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            Iterator bl4 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (bl4.hasNext()) {
                element$iv$iv = bl4.next();
                if (!(element$iv$iv instanceof TradeEvolution)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                TradeEvolution it3 = (TradeEvolution)element$iv;
                boolean bl5 = false;
                if (!it3.attemptEvolution(pokemon2, (Object)pokemon1)) continue;
                break;
            }
            $this$firstOrNull$iv = CobblemonEvents.TRADE_EVENT_POST;
            TradeEvent.Post[] $i$f$firstOrNull2 = new TradeEvent.Post[]{new TradeEvent.Post(player1, pokemon2, player2, pokemon1)};
            TradeEvent.Post[] events$iv = $i$f$firstOrNull2;
            boolean $i$f$post2 = false;
            $this$iv2.emit(Arrays.copyOf(events$iv, events$iv.length));
            TradeEvent.Post[] $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv$iv.length;
            for (int j = 0; j < n2; ++j) {
                TradeEvent.Post element$iv$iv2;
                TradeEvent.Post post2 = element$iv$iv2 = $this$forEach$iv$iv[j];
                boolean bl6 = false;
                TradeEvent.Post it4 = post2;
            }
        }
    }

    static {
        RequestManager.Companion.register(INSTANCE);
        activeTrades = new ArrayList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\nR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u001e\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0018R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "Lnet/minecraft/class_3222;", "sender", "receiver", "", "expiryTime", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)V", "component1", "()Lnet/minecraft/class_3222;", "component2", "component3", "()I", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getSender", "getReceiver", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "Ljava/util/UUID;", "requestID", "Ljava/util/UUID;", "getRequestID", "()Ljava/util/UUID;", "common"})
    public static final class TradeRequest
    implements ServerPlayerActionRequest {
        @NotNull
        private final class_3222 sender;
        @NotNull
        private final class_3222 receiver;
        private final int expiryTime;
        @NotNull
        private final String key;
        @NotNull
        private final UUID requestID;

        public TradeRequest(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            this.sender = sender;
            this.receiver = receiver;
            this.expiryTime = expiryTime;
            this.key = "trade";
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.requestID = uUID;
        }

        public /* synthetic */ TradeRequest(class_3222 class_32222, class_3222 class_32223, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 20;
            }
            this(class_32222, class_32223, n);
        }

        @Override
        @NotNull
        public class_3222 getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public class_3222 getReceiver() {
            return this.receiver;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public UUID getRequestID() {
            return this.requestID;
        }

        @NotNull
        public final class_3222 component1() {
            return this.sender;
        }

        @NotNull
        public final class_3222 component2() {
            return this.receiver;
        }

        public final int component3() {
            return this.expiryTime;
        }

        @NotNull
        public final TradeRequest copy(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            return new TradeRequest(sender, receiver, expiryTime);
        }

        public static /* synthetic */ TradeRequest copy$default(TradeRequest tradeRequest, class_3222 class_32222, class_3222 class_32223, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_32222 = tradeRequest.sender;
            }
            if ((n2 & 2) != 0) {
                class_32223 = tradeRequest.receiver;
            }
            if ((n2 & 4) != 0) {
                n = tradeRequest.expiryTime;
            }
            return tradeRequest.copy(class_32222, class_32223, n);
        }

        @NotNull
        public String toString() {
            return "TradeRequest(sender=" + this.sender + ", receiver=" + this.receiver + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TradeRequest)) {
                return false;
            }
            TradeRequest tradeRequest = (TradeRequest)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)tradeRequest.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)tradeRequest.receiver)) {
                return false;
            }
            return this.expiryTime == tradeRequest.expiryTime;
        }
    }
}

