/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.model.search;

import com.cobblemon.mod.relocations.mongodb.annotations.Beta;
import com.cobblemon.mod.relocations.mongodb.annotations.Sealed;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.model.search.FacetSearchCollector;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchFacet;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchOperator;
import org.bson.Document;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchCollector
extends Bson {
    @Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
    public static FacetSearchCollector facet(SearchOperator operator, Iterable<? extends SearchFacet> facets) {
        Assertions.notNull("operator", operator);
        Assertions.notNull("facets", facets);
        return new SearchConstructibleBsonElement("facet", (Bson)new Document("operator", operator).append("facets", SearchFacet.combineToBson(facets)));
    }

    public static SearchCollector of(Bson collector) {
        return new SearchConstructibleBsonElement(Assertions.notNull("collector", collector));
    }
}

