/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.api.profiles;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.Profile;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ValueProfile;
import java.util.Objects;

public final class PrimitiveValueProfile
extends ValueProfile {
    private static final PrimitiveValueProfile DISABLED;
    private static final Object UNINITIALIZED;
    private static final Object GENERIC;
    @CompilerDirectives.CompilationFinal
    private Object cachedValue = UNINITIALIZED;

    PrimitiveValueProfile() {
    }

    @Override
    public <T> T profile(T v) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            T value = v;
            if (snapshot instanceof Byte ? value instanceof Byte && ((Byte)snapshot).byteValue() == ((Byte)value).byteValue() : (snapshot instanceof Short ? value instanceof Short && ((Short)snapshot).shortValue() == ((Short)value).shortValue() : (snapshot instanceof Integer ? value instanceof Integer && ((Integer)snapshot).intValue() == ((Integer)value).intValue() : (snapshot instanceof Long ? value instanceof Long && ((Long)snapshot).longValue() == ((Long)value).longValue() : (snapshot instanceof Float ? value instanceof Float && Float.floatToRawIntBits(((Float)snapshot).floatValue()) == Float.floatToRawIntBits(((Float)value).floatValue()) : (snapshot instanceof Double ? value instanceof Double && Double.doubleToRawLongBits((Double)snapshot) == Double.doubleToRawLongBits((Double)value) : (snapshot instanceof Boolean ? value instanceof Boolean && ((Boolean)snapshot).booleanValue() == ((Boolean)value).booleanValue() : (snapshot instanceof Character ? value instanceof Character && ((Character)snapshot).charValue() == ((Character)value).charValue() : snapshot == value)))))))) {
                return (T)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return v;
    }

    public byte profile(byte value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Byte && (Byte)snapshot == value) {
                return (Byte)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public short profile(short value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Short && (Short)snapshot == value) {
                return (Short)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public int profile(int value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Integer && (Integer)snapshot == value) {
                return (Integer)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public long profile(long value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Long && (Long)snapshot == value) {
                return (Long)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public float profile(float value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Float && Float.floatToRawIntBits(((Float)snapshot).floatValue()) == Float.floatToRawIntBits(value)) {
                return ((Float)snapshot).floatValue();
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(Float.valueOf(value));
        }
        return value;
    }

    public double profile(double value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Double && Double.doubleToRawLongBits((Double)snapshot) == Double.doubleToRawLongBits(value)) {
                return (Double)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public boolean profile(boolean value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Boolean && (Boolean)snapshot == value) {
                return (Boolean)snapshot;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(value);
        }
        return value;
    }

    public char profile(char value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Character && ((Character)snapshot).charValue() == value) {
                return ((Character)snapshot).charValue();
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPath(Character.valueOf(value));
        }
        return value;
    }

    @Override
    public void disable() {
        this.cachedValue = GENERIC;
    }

    @Override
    public void reset() {
        if (this != DISABLED) {
            this.cachedValue = UNINITIALIZED;
        }
    }

    private void slowPath(Object value) {
        this.cachedValue = this.cachedValue == UNINITIALIZED ? value : GENERIC;
    }

    boolean isGeneric() {
        return this.cachedValue == GENERIC;
    }

    boolean isUninitialized() {
        return this.cachedValue == UNINITIALIZED;
    }

    Object getCachedValue() {
        return this.cachedValue;
    }

    public String toString() {
        if (this == DISABLED) {
            return this.toStringDisabled(PrimitiveValueProfile.class);
        }
        return this.toString(PrimitiveValueProfile.class, this.isUninitialized(), this.isGeneric(), this.formatSpecialization());
    }

    private String formatSpecialization() {
        if (!this.isUninitialized() && !this.isGeneric()) {
            Object snapshot = this.cachedValue;
            if (snapshot == null) {
                return String.format("value == null", new Object[0]);
            }
            if (snapshot instanceof Byte || snapshot instanceof Short || snapshot instanceof Integer || snapshot instanceof Long || snapshot instanceof Float || snapshot instanceof Double || snapshot instanceof Boolean || snapshot instanceof Character) {
                return String.format("value == (%s)%s", snapshot.getClass().getSimpleName(), snapshot);
            }
            String simpleName = snapshot.getClass().getSimpleName();
            return String.format("value == %s@%x", simpleName, Objects.hash(snapshot));
        }
        return null;
    }

    public static PrimitiveValueProfile createEqualityProfile() {
        return PrimitiveValueProfile.create();
    }

    public static PrimitiveValueProfile create() {
        if (Profile.isProfilingEnabled()) {
            return new PrimitiveValueProfile();
        }
        return DISABLED;
    }

    public static PrimitiveValueProfile getUncached() {
        return DISABLED;
    }

    static {
        PrimitiveValueProfile profile = new PrimitiveValueProfile();
        profile.disable();
        DISABLED = profile;
        UNINITIALIZED = new Object();
        GENERIC = new Object();
    }
}

