/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes;

import com.cobblemon.mod.relocations.graalvm.collections.EconomicMap;
import com.cobblemon.mod.relocations.oracle.js.parser.ir.Scope;
import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerAsserts;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.FrameDescriptor;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.FrameSlotKind;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JSFrameSlot;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Objects;
import java.util.StringJoiner;

public final class JSFrameDescriptor {
    private final Object defaultValue;
    private final EconomicMap<Object, JSFrameSlot> identifierToSlotMap = EconomicMap.create();
    private int size;
    private FrameDescriptor frameDescriptor;

    public JSFrameDescriptor() {
        this(Undefined.instance);
    }

    public JSFrameDescriptor(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public JSFrameSlot addFrameSlot(Object identifier2) {
        return this.addFrameSlot(identifier2, 0, FrameSlotKind.Illegal);
    }

    public JSFrameSlot addFrameSlot(Object identifier2, FrameSlotKind kind) {
        return this.addFrameSlot(identifier2, 0, kind);
    }

    public JSFrameSlot addFrameSlot(Object identifier2, int flags, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(identifier2, "identifier");
        Objects.requireNonNull(kind, "kind");
        if (this.isClosed()) {
            throw new IllegalArgumentException("frame slot registration is closed: " + identifier2);
        }
        if (this.identifierToSlotMap.containsKey(identifier2)) {
            throw new IllegalArgumentException("duplicate frame slot: " + identifier2);
        }
        int index = this.size;
        Object slotName = JSFrameDescriptor.toSlotName(identifier2);
        assert (JSFrameSlot.isAllowedIdentifierType(slotName)) : slotName.getClass();
        JSFrameSlot slot = new JSFrameSlot(index, slotName, JSFrameDescriptor.toSlotFlags(flags), kind);
        ++this.size;
        this.identifierToSlotMap.put(identifier2, slot);
        assert (this.identifierToSlotMap.size() == this.size);
        return slot;
    }

    public JSFrameSlot findFrameSlot(Object identifier2) {
        CompilerAsserts.neverPartOfCompilation();
        return (JSFrameSlot)this.identifierToSlotMap.get(identifier2);
    }

    public JSFrameSlot findOrAddFrameSlot(Object identifier2) {
        CompilerAsserts.neverPartOfCompilation();
        JSFrameSlot result = this.findFrameSlot(identifier2);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier2);
    }

    public JSFrameSlot findOrAddFrameSlot(Object identifier2, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation();
        JSFrameSlot result = this.findFrameSlot(identifier2);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier2, kind);
    }

    public JSFrameSlot findOrAddFrameSlot(Object identifier2, int flags, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation();
        JSFrameSlot result = this.findFrameSlot(identifier2);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier2, flags, kind);
    }

    public int getSize() {
        return this.size;
    }

    public boolean contains(Object identifier2) {
        CompilerAsserts.neverPartOfCompilation();
        return this.identifierToSlotMap.containsKey(identifier2);
    }

    public Iterable<Object> getIdentifiers() {
        CompilerAsserts.neverPartOfCompilation();
        return this.identifierToSlotMap.getKeys();
    }

    public Iterable<JSFrameSlot> getSlots() {
        CompilerAsserts.neverPartOfCompilation();
        return this.identifierToSlotMap.getValues();
    }

    public FrameDescriptor toFrameDescriptor() {
        FrameDescriptor descriptor;
        if (this.frameDescriptor != null) {
            return this.frameDescriptor;
        }
        FrameDescriptor.Builder b = FrameDescriptor.newBuilder(this.size);
        b.defaultValue(this.defaultValue);
        for (JSFrameSlot slot : this.identifierToSlotMap.getValues()) {
            int index = b.addSlot(slot.getKind(), slot.getIdentifier(), slot.getInfo());
            assert (slot.getIndex() == index);
        }
        this.frameDescriptor = descriptor = b.build();
        return descriptor;
    }

    public boolean isClosed() {
        return this.frameDescriptor != null;
    }

    public static JSFrameDescriptor createFunctionFrameDescriptor() {
        return new JSFrameDescriptor(Undefined.instance);
    }

    public static JSFrameDescriptor createBlockFrameDescriptor() {
        JSFrameDescriptor desc = new JSFrameDescriptor(Undefined.instance);
        desc.addFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER, FrameSlotKind.Object);
        return desc;
    }

    private static int toSlotFlags(int flags) {
        return flags & 0x80BE4113;
    }

    private static Object toSlotName(Object identifier2) {
        if (identifier2 instanceof ScopedIdentifier) {
            return ((ScopedIdentifier)identifier2).identifier;
        }
        return identifier2;
    }

    public static ScopedIdentifier scopedIdentifier(Object identifier2, Scope scope) {
        return new ScopedIdentifier(identifier2, scope);
    }

    public String toString() {
        StringJoiner slots = new StringJoiner(", ", "{", "}");
        for (JSFrameSlot slot : this.identifierToSlotMap.getValues()) {
            slots.add(slot.getIdentifier().toString());
        }
        return "FrameDescriptor[size=" + this.size + ", slots=" + slots + "]";
    }

    private static final class ScopedIdentifier {
        final Object identifier;
        final Scope scope;

        ScopedIdentifier(Object identifier2, Scope scope) {
            this.identifier = Objects.requireNonNull(identifier2);
            this.scope = scope;
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.scope);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ScopedIdentifier)) {
                return false;
            }
            ScopedIdentifier other = (ScopedIdentifier)obj;
            return Objects.equals(this.identifier, other.identifier) && Objects.equals(this.scope, other.scope);
        }

        public String toString() {
            return this.identifier.toString();
        }
    }
}

