/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Executed;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JSFrameSlot;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.LocalVarPostfixIncNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.LocalVarPrefixIncNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.BigInt;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.SafeInteger;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;

public abstract class LocalVarIncNode
extends FrameSlotNode.WithDescriptor {
    protected final LocalVarOp op;
    protected final boolean hasTemporalDeadZone;
    @Node.Child
    @Executed
    protected ScopeFrameNode scopeFrameNode;

    protected LocalVarIncNode(LocalVarOp op, int slot, Object identifier2, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        super(slot, identifier2);
        this.op = op;
        this.hasTemporalDeadZone = hasTemporalDeadZone;
        this.scopeFrameNode = scopeFrameNode;
    }

    public static LocalVarIncNode createPrefix(Op op, JSFrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        return LocalVarPrefixIncNodeGen.create(op.op, frameSlot.getIndex(), frameSlot.getIdentifier(), hasTemporalDeadZone, scopeFrameNode);
    }

    public static LocalVarIncNode createPostfix(Op op, JSFrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        return LocalVarPostfixIncNodeGen.create(op.op, frameSlot.getIndex(), frameSlot.getIdentifier(), hasTemporalDeadZone, scopeFrameNode);
    }

    @Override
    public final boolean hasTemporalDeadZone() {
        return this.hasTemporalDeadZone;
    }

    @Override
    public final ScopeFrameNode getLevelFrameNode() {
        return this.scopeFrameNode;
    }

    protected static class DecOp
    extends LocalVarOp {
        protected DecOp() {
        }

        @Override
        public int doInt(int value) {
            return Math.subtractExact(value, 1);
        }

        @Override
        public double doDouble(double value) {
            return value - 1.0;
        }

        @Override
        public Number doNumber(Number numValue, ConditionProfile isIntegerProfile, ConditionProfile isBoundaryValue) {
            if (isIntegerProfile.profile(numValue instanceof Integer)) {
                int intValue = (Integer)numValue;
                if (isBoundaryValue.profile(intValue != Integer.MIN_VALUE)) {
                    return intValue - 1;
                }
                return (double)intValue - 1.0;
            }
            double doubleValue = JSRuntime.doubleValue(numValue);
            return doubleValue - 1.0;
        }

        @Override
        public BigInt doBigInt(BigInt value) {
            return value.subtract(BigInt.ONE);
        }

        @Override
        public SafeInteger doSafeInteger(SafeInteger value) {
            return value.decrementExact();
        }

        @Override
        public TruffleString getOverloadedOperatorName() {
            return Strings.SYMBOL_MINUS_MINUS;
        }
    }

    protected static class IncOp
    extends LocalVarOp {
        protected IncOp() {
        }

        @Override
        public int doInt(int value) {
            return Math.addExact(value, 1);
        }

        @Override
        public double doDouble(double value) {
            return value + 1.0;
        }

        @Override
        public Number doNumber(Number numValue, ConditionProfile isIntegerProfile, ConditionProfile isBoundaryValue) {
            if (isIntegerProfile.profile(numValue instanceof Integer)) {
                int intValue = (Integer)numValue;
                if (isBoundaryValue.profile(intValue != Integer.MAX_VALUE)) {
                    return intValue + 1;
                }
                return (double)intValue + 1.0;
            }
            double doubleValue = JSRuntime.doubleValue(numValue);
            return doubleValue + 1.0;
        }

        @Override
        public BigInt doBigInt(BigInt value) {
            return value.add(BigInt.ONE);
        }

        @Override
        public SafeInteger doSafeInteger(SafeInteger value) {
            return value.incrementExact();
        }

        @Override
        public TruffleString getOverloadedOperatorName() {
            return Strings.SYMBOL_PLUS_PLUS;
        }
    }

    static abstract class LocalVarOp {
        LocalVarOp() {
        }

        public abstract int doInt(int var1);

        public abstract double doDouble(double var1);

        public abstract Number doNumber(Number var1, ConditionProfile var2, ConditionProfile var3);

        public abstract BigInt doBigInt(BigInt var1);

        public abstract SafeInteger doSafeInteger(SafeInteger var1);

        public abstract TruffleString getOverloadedOperatorName();
    }

    public static enum Op {
        Inc(new IncOp()),
        Dec(new DecOp());

        public final LocalVarOp op;

        private Op(LocalVarOp op) {
            this.op = op;
        }
    }
}

