/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.temporal;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IsObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.temporal.ToLimitedTemporalDurationNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Boundaries;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.TemporalErrors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToLimitedTemporalDurationNode
extends JavaScriptBaseNode {
    private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasDisallowedFields = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorBranch = BranchProfile.create();

    protected ToLimitedTemporalDurationNode() {
    }

    public static ToLimitedTemporalDurationNode create() {
        return ToLimitedTemporalDurationNodeGen.create();
    }

    public abstract JSTemporalDurationRecord executeDynamicObject(Object var1, List<TruffleString> var2);

    @Specialization
    protected JSTemporalDurationRecord toLimitedTemporalDuration(Object temporalDurationLike, List<TruffleString> disallowedFields, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode) {
        JSTemporalDurationRecord d;
        if (this.isObjectProfile.profile(!isObjectNode.executeBoolean(temporalDurationLike))) {
            TruffleString str = toStringNode.executeString(temporalDurationLike);
            d = JSTemporalDuration.parseTemporalDurationString(str);
        } else {
            d = JSTemporalDuration.toTemporalDurationRecord((JSDynamicObject)temporalDurationLike);
        }
        if (this.hasDisallowedFields.profile(disallowedFields != TemporalUtil.listEmpty)) {
            for (TemporalUtil.UnitPlural unit : TemporalUtil.DURATION_PROPERTIES) {
                double value = TemporalUtil.getPropertyFromRecord(d, unit);
                if (value == 0.0 || !Boundaries.listContains(disallowedFields, unit.toTruffleString())) continue;
                this.errorBranch.enter();
                throw TemporalErrors.createRangeErrorDisallowedField(unit.toTruffleString());
            }
        }
        return d;
    }
}

