/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.wasm;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;

public abstract class ToWebAssemblyIndexOrSizeNode
extends JavaScriptBaseNode {
    private final String errorMessagePrefix;
    private final BranchProfile errorBranch;
    @Node.Child
    JSToNumberNode toNumberNode;

    protected ToWebAssemblyIndexOrSizeNode(String errorMessagePrefix) {
        this.errorMessagePrefix = errorMessagePrefix;
        this.errorBranch = BranchProfile.create();
        this.toNumberNode = JSToNumberNode.create();
    }

    public static ToWebAssemblyIndexOrSizeNode create(String errorMessagePrefix) {
        return ToWebAssemblyIndexOrSizeNodeGen.create(errorMessagePrefix);
    }

    public abstract double executeDouble(Object var1);

    public int executeInt(Object value) {
        double valueDouble = this.executeDouble(value);
        if (valueDouble > 2.147483647E9) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be in the int range", this.errorMessagePrefix);
        }
        return (int)valueDouble;
    }

    @Specialization
    protected double convert(Object value) {
        Number valueNumber = this.toNumberNode.executeNumber(value);
        double valueDouble = JSRuntime.doubleValue(valueNumber);
        if (Double.isNaN(valueDouble)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be convertible to a valid number", this.errorMessagePrefix);
        }
        if (valueDouble < 0.0) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be non-negative", this.errorMessagePrefix);
        }
        return valueDouble;
    }
}

