/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class InventoryEntityComponent<E extends class_1297>
extends EntityComponent<E> {
    private float startingRotation = -45.0f;
    private float lastBbWidth = 0.0f;
    private float lastBbHeight = 0.0f;
    private ScaleFitType type = ScaleFitType.NONE;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    private TriConsumer<OwoUIDrawContext, Component, Runnable> renderWrapping = (ctx, component, runnable) -> runnable.run();

    public InventoryEntityComponent(Sizing sizing, E entity) {
        super(sizing, entity);
        this.lastBbWidth = entity.method_17681();
        this.lastBbHeight = entity.method_17682();
    }

    public InventoryEntityComponent(Sizing sizing, class_1299<E> type, @Nullable class_2487 nbt) {
        super(sizing, type, nbt);
    }

    public static <E extends class_1297> InventoryEntityComponent<E> of(Sizing verticalSizing, Sizing horizontalSizing, E entity) {
        InventoryEntityComponent<E> component = new InventoryEntityComponent<E>(verticalSizing, entity);
        component.horizontalSizing(horizontalSizing);
        return component;
    }

    private float getEntityScale() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            f = living.method_55693();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public InventoryEntityComponent<E> renderWrapping(TriConsumer<OwoUIDrawContext, Component, Runnable> renderWrapping) {
        this.renderWrapping = renderWrapping;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFit(boolean scaleToFit) {
        if (scaleToFit) {
            float componentHeight = ((Sizing)this.verticalSizing().get()).value;
            float componentWidth = (float)((Sizing)this.horizontalSizing().get()).value - 40.0f;
            float entityHeight = this.entity.method_17682() * (Math.min(componentWidth, componentHeight) / Math.max(componentWidth, componentHeight));
            float entityWidth = this.entity.method_17681() * (Math.max(componentWidth, componentHeight) / Math.min(componentWidth, componentHeight));
            float length = Math.max(entityHeight, entityWidth);
            float baseScale = 0.35f / length;
            this.scale(baseScale);
            this.type = ScaleFitType.BOTH;
        } else {
            this.scale(1.0f);
            this.type = ScaleFitType.NONE;
        }
        return this;
    }

    public InventoryEntityComponent<E> startingRotation(float value) {
        this.startingRotation = value;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitVertically(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.method_17682() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.VERTICAL : ScaleFitType.NONE;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitHorizontally(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.method_17681() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.HORIZONTAL : ScaleFitType.NONE;
        return this;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_1297 class_12972 = this.entity;
        if (!(class_12972 instanceof class_1309)) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            return;
        }
        class_1309 living = (class_1309)class_12972;
        if (this.lastBbWidth != this.entity.method_17681() || this.lastBbHeight != this.entity.method_17682()) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.scaleToFitVertically(true);
                    break;
                }
                case 1: {
                    this.scaleToFitHorizontally(true);
                    break;
                }
                case 2: {
                    this.scaleToFit(true);
                    break;
                }
            }
            this.lastBbWidth = this.entity.method_17681();
            this.lastBbHeight = this.entity.method_17682();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        int maxLength = Math.max(this.width, this.height);
        matrices.method_46416((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 60.0f);
        matrices.method_22905(75.0f * this.scale * (float)maxLength / 64.0f, -75.0f * this.scale * (float)maxLength / 64.0f, 75.0f * this.scale);
        matrices.method_46416(0.0f, this.entity.method_17682() / -2.0f, 0.0f);
        matrices.method_46416(this.xOffset, this.yOffset, 0.0f);
        this.transform.accept(matrices);
        float prevYBodyRot0 = living.field_6220;
        float prevYBodyRot = living.field_6283;
        float prevYRot = living.method_36454();
        float prevYRot0 = living.field_5982;
        float prevXRot = living.method_36455();
        float prevXRot0 = living.field_6004;
        float prevYHeadRot0 = living.field_6259;
        float prevYHeadRot = living.field_6241;
        OwoEntityRenderDispatcherExtension dispatcher = (OwoEntityRenderDispatcherExtension)this.dispatcher;
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            living.field_6259 = -yRotation;
            this.entity.field_5982 = -yRotation;
            this.entity.field_6004 = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(xRotation * 0.35f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(yRotation * 0.555f));
        } else {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            this.entity.field_6004 = xRotation * 0.35f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(15.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(this.startingRotation + this.mouseRotation));
        }
        dispatcher.owo$setCounterRotate(true);
        dispatcher.owo$setShowNametag(this.showNametag);
        class_308.method_34742();
        this.dispatcher.method_3948(false);
        living.field_6220 = 0.0f;
        living.field_6283 = 0.0f;
        living.method_36456(0.0f);
        living.field_6241 = living.field_6283;
        living.field_6259 = living.field_6220;
        RenderSystem.disableDepthTest();
        this.renderWrapping.accept((Object)context, (Object)this, () -> this.dispatcher.method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (class_4597)this.entityBuffers, 0xF000F0));
        this.dispatcher.method_3948(true);
        living.field_6220 = prevYBodyRot0;
        living.field_6283 = prevYBodyRot;
        living.method_36456(prevYRot);
        living.field_5982 = prevYRot0;
        living.method_36457(prevXRot);
        living.field_6004 = prevXRot0;
        living.field_6259 = prevYHeadRot0;
        living.field_6241 = prevYHeadRot;
        this.dispatcher.method_3948(true);
        this.entityBuffers.method_22993();
        class_308.method_24211();
        matrices.method_22909();
        dispatcher.owo$setCounterRotate(false);
        dispatcher.owo$setShowNametag(true);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scale += (float)(amount * (double)this.scale * (double)0.1f);
        return true;
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.xOffset -= 0.05f;
        } else if (keyCode == 262) {
            this.xOffset += 0.05f;
        }
        if (keyCode == 265) {
            this.yOffset += 0.05f;
        } else if (keyCode == 264) {
            this.yOffset -= 0.05f;
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    public static enum ScaleFitType {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;

    }
}

