/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1320;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ResourceExtendedArgument<T>
implements ArgumentType<class_6880<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_NOT_SUMMONABLE_ENTITY = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"entity.not_summonable", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_RESOURCE = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_54159((String)"argument.resource.not_found", (Object[])new Object[]{object, object2}));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_RESOURCE_TYPE = new Dynamic3CommandExceptionType((object, object2, object3) -> class_2561.method_54159((String)"argument.resource.invalid_type", (Object[])new Object[]{object, object2, object3}));
    final class_5321<? extends class_2378<T>> registryKey;
    private final class_7225<T> registryLookup;
    private final Function<class_2960, @Nullable class_6880<T>> additionalLookup;
    private final Supplier<Stream<class_2960>> additionalSuggestions;

    public ResourceExtendedArgument(class_7157 context, class_5321<? extends class_2378<T>> registryKey, Function<class_2960, @Nullable class_6880<T>> additionalLookup, Supplier<Stream<class_2960>> additionalSuggestions) {
        this.registryKey = registryKey;
        this.registryLookup = context.method_46762(registryKey);
        this.additionalLookup = additionalLookup;
        this.additionalSuggestions = additionalSuggestions;
    }

    public static <T> ResourceExtendedArgument<T> resource(class_7157 context, class_5321<? extends class_2378<T>> registryKey, Function<class_2960, @Nullable class_6880<T>> additionalLookup, Supplier<Stream<class_2960>> additionalSuggestions) {
        return new ResourceExtendedArgument<T>(context, registryKey, additionalLookup, additionalSuggestions);
    }

    public static ResourceExtendedArgument<class_1320> attributes(class_7157 context) {
        return new ResourceExtendedArgument<class_1320>(context, class_7924.field_41251, location -> {
            String possibleSlotName = location.method_12836().equals("accessories") ? location.method_12832() : location.toString();
            SlotType slotType = SlotTypeLoader.INSTANCE.getSlotTypes(false).get(possibleSlotName);
            return slotType != null ? SlotAttribute.getAttributeHolder(possibleSlotName) : null;
        }, () -> SlotTypeLoader.INSTANCE.getSlotTypes(false).values().stream().map(SlotType::name).map(s -> s.contains(":") ? class_2960.method_60654((String)s) : Accessories.of(s)));
    }

    public static class_6880<class_1320> getAttribute(CommandContext<class_2168> commandContext, String string) {
        return ResourceExtendedArgument.getResource(commandContext, string);
    }

    public static <T> class_6880<T> getResource(CommandContext<class_2168> context, String argument) {
        return (class_6880)context.getArgument(argument, class_6880.class);
    }

    public class_6880<T> parse(StringReader builder) throws CommandSyntaxException {
        class_2960 resourceLocation = class_2960.method_12835((StringReader)builder);
        class_5321 resourceKey = class_5321.method_29179(this.registryKey, (class_2960)resourceLocation);
        Optional<class_6880> entry = this.registryLookup.method_46746(resourceKey).map(tReference -> tReference).or(() -> Optional.ofNullable(this.additionalLookup.apply(resourceLocation)));
        return entry.orElseThrow(() -> ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)builder, (Object)resourceLocation, (Object)this.registryKey.method_29177()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        Stream<class_2960> registryKeys = this.registryLookup.method_46754().map(class_5321::method_29177);
        Stream<class_2960> extraEntries = this.additionalSuggestions.get();
        return class_2172.method_9257(Stream.concat(registryKeys, extraEntries), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

