/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5151;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ArmorSlotTypes
implements UniqueSlotHandling.RegistrationCallback {
    private static final Accessory armorAccessory = new Accessory(){

        @Override
        @Nullable
        public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
            class_6880 class_68802;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_5151) {
                class_5151 equipable = (class_5151)class_17922;
                class_68802 = equipable.method_31570();
            } else {
                class_68802 = class_3417.field_14883;
            }
            class_6880 sound = class_68802;
            return new SoundEventData((class_6880<class_3414>)sound, 1.0f, 1.0f);
        }
    };
    public static final Map<class_1304, class_2960> TEXTURE_EMPTY_SLOTS = Map.of(class_1304.field_6166, class_2960.method_60656((String)"item/empty_armor_slot_boots"), class_1304.field_6172, class_2960.method_60656((String)"item/empty_armor_slot_leggings"), class_1304.field_6174, class_2960.method_60656((String)"item/empty_armor_slot_chestplate"), class_1304.field_6169, class_2960.method_60656((String)"item/empty_armor_slot_helmet"));
    public static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public static final ArmorSlotTypes INSTANCE = new ArmorSlotTypes();
    private static final class_2960 HEAD_PREDICATE_LOCATION = Accessories.of("head");
    private static final class_2960 CHEST_PREDICATE_LOCATION = Accessories.of("chest");
    private static final class_2960 LEGS_PREDICATE_LOCATION = Accessories.of("legs");
    private static final class_2960 FEET_PREDICATE_LOCATION = Accessories.of("feet");
    private static final class_2960 ANIMAL_BODY_PREDICATE_LOCATION = Accessories.of("animal_body");
    private SlotTypeReference headSlotReference = null;
    private SlotTypeReference chestSlotReference = null;
    private SlotTypeReference legsSlotReference = null;
    private SlotTypeReference feetSlotReference = null;
    private SlotTypeReference animalBodySlotReference = null;
    public static final class_2960 SPRITE_ATLAS_LOCATION = class_2960.method_60656((String)"textures/atlas/gui.png");
    private static final class_2960 LLAMA_ARMOR_SLOT_SPRITE = class_2960.method_60656((String)"container/horse/llama_armor_slot");
    private static final class_2960 HORSE_ARMOR_SLOT_SPRITE = class_2960.method_60656((String)"container/horse/armor_slot");

    private ArmorSlotTypes() {
    }

    public static boolean isArmorType(String slotType) {
        return ArmorSlotTypes.headSlot().slotName().equals(slotType) || ArmorSlotTypes.chestSlot().slotName().equals(slotType) || ArmorSlotTypes.legsSlot().slotName().equals(slotType) || ArmorSlotTypes.feetSlot().slotName().equals(slotType);
    }

    public static SlotTypeReference headSlot() {
        return ArmorSlotTypes.INSTANCE.headSlotReference;
    }

    public static SlotTypeReference chestSlot() {
        return ArmorSlotTypes.INSTANCE.chestSlotReference;
    }

    public static SlotTypeReference legsSlot() {
        return ArmorSlotTypes.INSTANCE.legsSlotReference;
    }

    public static SlotTypeReference feetSlot() {
        return ArmorSlotTypes.INSTANCE.feetSlotReference;
    }

    public static SlotTypeReference animalBody() {
        return ArmorSlotTypes.INSTANCE.animalBodySlotReference;
    }

    public static List<SlotTypeReference> getArmorReferences() {
        return List.of(ArmorSlotTypes.headSlot(), ArmorSlotTypes.chestSlot(), ArmorSlotTypes.legsSlot(), ArmorSlotTypes.feetSlot());
    }

    @Nullable
    public static @Nullable Pair<@Nullable class_2960, class_2960> getEmptyTexture(class_1304 slot, class_1309 living) {
        class_1496 horse;
        class_2960 texture = TEXTURE_EMPTY_SLOTS.get(slot);
        if (texture != null) {
            return Pair.of(null, (Object)texture);
        }
        if (living instanceof class_1496 && (horse = (class_1496)living).method_56991(class_1304.field_48824)) {
            if (horse instanceof class_1501) {
                return Pair.of((Object)SPRITE_ATLAS_LOCATION, (Object)LLAMA_ARMOR_SLOT_SPRITE);
            }
            return Pair.of((Object)SPRITE_ATLAS_LOCATION, (Object)HORSE_ARMOR_SLOT_SPRITE);
        }
        return null;
    }

    @Nullable
    public static SlotTypeReference getReferenceFromSlot(class_1304 equipmentSlot) {
        return switch (equipmentSlot) {
            case class_1304.field_6169 -> ArmorSlotTypes.headSlot();
            case class_1304.field_6174 -> ArmorSlotTypes.chestSlot();
            case class_1304.field_6172 -> ArmorSlotTypes.legsSlot();
            case class_1304.field_6166 -> ArmorSlotTypes.feetSlot();
            case class_1304.field_48824 -> ArmorSlotTypes.animalBody();
            default -> null;
        };
    }

    public static boolean isValidEquipable(class_1304 equipmentSlot) {
        return switch (equipmentSlot) {
            case class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166, class_1304.field_48824 -> true;
            default -> false;
        };
    }

    public void init() {
        UniqueSlotHandling.EVENT.register((Object)this);
        AccessoriesAPI.registerPredicate(HEAD_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, class_1304.field_6169));
        AccessoriesAPI.registerPredicate(CHEST_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, class_1304.field_6174));
        AccessoriesAPI.registerPredicate(LEGS_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, class_1304.field_6172));
        AccessoriesAPI.registerPredicate(FEET_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, class_1304.field_6166));
        AccessoriesAPI.registerPredicate(ANIMAL_BODY_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, class_1304.field_48824));
    }

    public void registerAccessories(Consumer<TriConsumer<Integer, class_2960, class_1792>> eventRegister) {
        class_7923.field_41178.forEach(this::tryToRegisterItem);
        eventRegister.accept((TriConsumer<Integer, class_2960, class_1792>)((TriConsumer)(integer, resourceLocation, item) -> this.tryToRegisterItem((class_1792)item)));
    }

    private void tryToRegisterItem(class_1792 item) {
        Accessory accessory;
        class_5151 equipable;
        if (item instanceof class_5151 && ArmorSlotTypes.isValidEquipable((equipable = (class_5151)item).method_7685()) && (accessory = AccessoriesAPI.getAccessory(item)) == null) {
            AccessoriesAPI.registerAccessory(item, armorAccessory);
        }
    }

    @Override
    public void registerSlots(UniqueSlotHandling.UniqueSlotBuilderFactory factory) {
        this.headSlotReference = factory.create(Accessories.of("head"), 1).allowTooltipInfo(false).slotPredicates(HEAD_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(class_1299.field_6097, class_1299.field_6131).build();
        this.chestSlotReference = factory.create(Accessories.of("chest"), 1).allowTooltipInfo(false).slotPredicates(CHEST_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(class_1299.field_6097, class_1299.field_6131).build();
        this.legsSlotReference = factory.create(Accessories.of("legs"), 1).allowTooltipInfo(false).slotPredicates(LEGS_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(class_1299.field_6097, class_1299.field_6131).build();
        this.feetSlotReference = factory.create(Accessories.of("feet"), 1).allowTooltipInfo(false).slotPredicates(FEET_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(class_1299.field_6097, class_1299.field_6131).build();
        this.animalBodySlotReference = factory.create(Accessories.of("animal_body"), 1).allowTooltipInfo(false).slotPredicates(ANIMAL_BODY_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(class_1299.field_6139, class_1299.field_6055).build();
    }

    private static TriState isValid(class_1309 livingEntity, class_1799 stack, class_1304 equipmentSlot) {
        class_1304 stackEquipmentSlot = null;
        if (livingEntity == null) {
            class_5151 equipable = class_5151.method_48957((class_1799)stack);
            if (equipable != null) {
                stackEquipmentSlot = equipable.method_7685();
            }
        } else {
            stackEquipmentSlot = livingEntity.method_32326(stack);
        }
        return equipmentSlot.equals((Object)stackEquipmentSlot) ? TriState.TRUE : TriState.DEFAULT;
    }

    @Nullable
    public static class_1799 getAlternativeStack(class_1309 instance, class_1304 equipmentSlot) {
        AccessoriesContainer container;
        SlotTypeReference reference;
        AccessoriesCapability capability = instance.accessoriesCapability();
        if (capability != null && (reference = ArmorSlotTypes.getReferenceFromSlot(equipmentSlot)) != null && (container = capability.getContainer(reference)) != null) {
            if (!container.shouldRender(0)) {
                return class_1799.field_8037;
            }
            class_1799 stack = container.getCosmeticAccessories().method_5438(0);
            if (!stack.method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                return stack;
            }
        }
        return null;
    }
}

