/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class WrappingCollection<K, C extends Collection<K>>
implements Collection<K> {
    private final C innerSet;
    private final Function<Object, K> unpacker;
    private final Predicate<K> keyValidator;

    WrappingCollection(C innerSet, Function<Object, K> unpacker, Predicate<K> keyValidator) {
        this.innerSet = innerSet;
        this.unpacker = unpacker;
        this.keyValidator = keyValidator;
    }

    @Override
    public int size() {
        int count = 0;
        for (Object k : this.innerSet) {
            if (!this.keyValidator.test(k)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() != 0;
    }

    @Override
    public boolean contains(Object o) {
        K k = this.unpacker.apply(o);
        return k != null && this.keyValidator.test(k) && this.innerSet.contains(o);
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        final Iterator itr = this.innerSet.iterator();
        return new Iterator<K>(){
            private K entry = null;

            @Override
            public boolean hasNext() {
                if (this.entry == null && itr.hasNext()) {
                    Object entry = itr.next();
                    while (!WrappingCollection.this.keyValidator.test(entry) && itr.hasNext()) {
                        entry = itr.next();
                    }
                }
                return this.entry != null;
            }

            @Override
            public K next() {
                Object entry = this.entry;
                this.entry = null;
                return entry;
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        ArrayList list = new ArrayList();
        for (Object k : this.innerSet) {
            if (!this.keyValidator.test(k)) continue;
            list.add(k);
        }
        return list.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        ArrayList list = new ArrayList();
        for (Object k : this.innerSet) {
            if (!this.keyValidator.test(k)) continue;
            list.add(k);
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(K k) {
        return (Boolean)WrappingCollection.throwUnsupported("add");
    }

    @Override
    public boolean remove(Object o) {
        return (Boolean)WrappingCollection.throwUnsupported("remove");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return (Boolean)WrappingCollection.throwUnsupported("containsAll");
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> c) {
        return (Boolean)WrappingCollection.throwUnsupported("addAll");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return (Boolean)WrappingCollection.throwUnsupported("retainAll");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return (Boolean)WrappingCollection.throwUnsupported("removeAll");
    }

    @Override
    public void clear() {
        WrappingCollection.throwUnsupported("clear");
    }

    private static <T> T throwUnsupported(String methodName) {
        throw new UnsupportedOperationException("Unable to use '" + methodName + "' as such is not support as its Immutable!");
    }
}

